/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.entity.ai.goal.FlockToSameKindGoal;
import twilightforest.entity.ai.goal.PanicOnFlockDeathGoal;
import twilightforest.init.TFSounds;

public class Kobold
extends Monster {
    private static final EntityDataAccessor<Boolean> PANICKED = SynchedEntityData.m_135353_(Kobold.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int lastEatenBreadTicks;
    private int eatingTime;

    public Kobold(EntityType<? extends Kobold> type, Level world) {
        super(type, world);
        this.m_21553_(true);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicOnFlockDeathGoal((PathfinderMob)this, 2.0f));
        this.f_21345_.m_25352_(2, (Goal)new SeekBreadGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RunAwayWhileHoldingBreadGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new FlockToSameKindGoal((Mob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new KoboldAttackPlayerTarget(this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(PANICKED, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 13.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.KOBOLD_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.KOBOLD_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.KOBOLD_DEATH.get();
    }

    public boolean isPanicked() {
        return (Boolean)this.m_20088_().m_135370_(PANICKED);
    }

    public void setPanicked(boolean flag) {
        this.m_20088_().m_135381_(PANICKED, (Object)flag);
    }

    public SoundEvent m_7866_(ItemStack stack) {
        return (SoundEvent)TFSounds.KOBOLD_MUNCH.get();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().m_5776_() && this.isPanicked()) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_() * 0.5, this.m_20186_() + (double)this.m_20192_(), this.m_20189_() + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_() * 0.5, 0.0, 0.0, 0.0);
            }
        }
        if (!this.m_9236_().m_5776_() && this.m_6084_() && this.m_6844_(EquipmentSlot.MAINHAND).m_204117_(ItemTagGenerator.KOBOLD_PACIFICATION_BREADS)) {
            ItemStack itemstack;
            ++this.lastEatenBreadTicks;
            if (this.eatingTime > 0) {
                --this.eatingTime;
            }
            if (this.canEat(itemstack = this.m_6844_(EquipmentSlot.MAINHAND))) {
                ItemStack itemstack1;
                if (this.eatingTime <= 0 && !(itemstack1 = itemstack.m_41671_(this.m_9236_(), (LivingEntity)this)).m_41619_()) {
                    this.m_8061_(EquipmentSlot.MAINHAND, itemstack1);
                }
                if (this.lastEatenBreadTicks > 60 && this.m_217043_().m_188501_() < 0.1f) {
                    this.m_5496_(this.m_7866_(itemstack), 0.75f, 0.9f);
                    this.m_146850_(GameEvent.f_157806_);
                    this.m_9236_().m_7605_((Entity)this, (byte)45);
                    this.lastEatenBreadTicks = 0;
                }
            }
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 45) {
            ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!itemstack.m_41619_()) {
                this.m_21060_(itemstack, 8);
            }
        } else {
            super.m_7822_(pId);
        }
    }

    private void m_21060_(ItemStack stack, int amount) {
        for (int i = 0; i < amount; ++i) {
            Vec3 vec3 = new Vec3(((double)this.m_217043_().m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
            vec3 = vec3.m_82524_(-this.m_6080_() * ((float)Math.PI / 180));
            double d0 = (double)(-this.m_217043_().m_188501_()) * 0.6 - 0.3;
            Vec3 vec31 = new Vec3(((double)this.m_217043_().m_188501_() - 0.5) * 0.3, d0, 0.6);
            vec31 = vec31.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
            vec31 = vec31.m_82524_(-this.m_6080_() * ((float)Math.PI / 180));
            vec31 = vec31.m_82520_(this.m_20185_(), this.m_20188_(), this.m_20189_());
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                server.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), vec31.m_7096_(), vec31.m_7098_(), vec31.m_7094_(), 1, vec3.m_7096_(), vec3.m_7098_() + 0.05, vec3.m_7094_(), 0.0);
                continue;
            }
            this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), vec31.m_7096_(), vec31.m_7098_(), vec31.m_7094_(), vec3.m_7096_(), vec3.m_7098_() + 0.05, vec3.m_7094_());
        }
    }

    private boolean canEat(ItemStack stack) {
        return stack.m_41720_().m_41472_() && !this.isPanicked();
    }

    public boolean m_7066_(ItemStack stack) {
        EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)stack);
        if (!this.m_6844_(equipmentslot).m_41619_()) {
            return false;
        }
        return equipmentslot == EquipmentSlot.MAINHAND && super.m_7066_(stack);
    }

    public boolean m_7252_(ItemStack stack) {
        return this.m_6844_(EquipmentSlot.MAINHAND).m_41619_() && stack.m_204117_(ItemTagGenerator.KOBOLD_PACIFICATION_BREADS) && !this.isPanicked();
    }

    protected void m_7581_(ItemEntity item) {
        ItemStack itemstack = item.m_32055_();
        if (this.m_7252_(itemstack)) {
            int i = itemstack.m_41613_();
            if (i > 1) {
                this.dropItemStack(itemstack.m_41620_(i - 1));
            }
            this.m_21053_(item);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)item, itemstack.m_41613_());
            this.m_146850_(GameEvent.f_157811_);
            item.m_146870_();
            this.lastEatenBreadTicks = 1;
            this.eatingTime = this.difficultyTime() + this.m_217043_().m_188503_(600);
            this.m_6710_(null);
        }
    }

    private int difficultyTime() {
        switch (this.m_9236_().m_46791_()) {
            case EASY: {
                return 400;
            }
            case NORMAL: {
                return 200;
            }
            case HARD: {
                return 100;
            }
        }
        return 200;
    }

    private void dropItemStack(ItemStack stack) {
        ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        this.m_9236_().m_7967_((Entity)itementity);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("EatingTimeLeft", this.eatingTime);
        tag.m_128405_("TimeSinceBreadLastEaten", this.lastEatenBreadTicks);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.eatingTime = tag.m_128451_("EatingTimeLeft");
        this.lastEatenBreadTicks = tag.m_128451_("TimeSinceBreadLastEaten");
    }

    public int m_5792_() {
        return 1;
    }

    private static class SeekBreadGoal
    extends Goal {
        private static final Predicate<ItemEntity> ALLOWED_ITEMS = item -> item.m_32055_().m_204117_(ItemTagGenerator.KOBOLD_PACIFICATION_BREADS);
        private final Kobold mob;

        public SeekBreadGoal(Kobold mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.mob = mob;
        }

        public boolean m_8036_() {
            if (!this.mob.m_21211_().m_41619_()) {
                return false;
            }
            if (!this.mob.isPanicked()) {
                if (this.mob.m_217043_().m_188503_(10) != 0) {
                    return false;
                }
                List list = this.mob.m_9236_().m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
                return !list.isEmpty() && this.mob.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
            }
            return false;
        }

        public void m_8037_() {
            List list = this.mob.m_9236_().m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            ItemStack itemstack = this.mob.m_6844_(EquipmentSlot.MAINHAND);
            if (itemstack.m_41619_() && !list.isEmpty()) {
                this.mob.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
                this.mob.m_21563_().m_24946_(((ItemEntity)list.get(0)).m_20185_(), ((ItemEntity)list.get(0)).m_20186_(), ((ItemEntity)list.get(0)).m_20189_());
            }
        }

        public void m_8056_() {
            List list = this.mob.m_9236_().m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!list.isEmpty()) {
                this.mob.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    private static class RunAwayWhileHoldingBreadGoal
    extends AvoidEntityGoal<Player> {
        public RunAwayWhileHoldingBreadGoal(Kobold mob) {
            super((PathfinderMob)mob, Player.class, 8.0f, 1.5, 1.5);
        }

        public boolean m_8036_() {
            if (this.f_25015_.m_6844_(EquipmentSlot.MAINHAND).m_204117_(ItemTagGenerator.KOBOLD_PACIFICATION_BREADS)) {
                return super.m_8036_();
            }
            return false;
        }
    }

    private static class KoboldAttackPlayerTarget
    extends NearestAttackableTargetGoal<Player> {
        public KoboldAttackPlayerTarget(Kobold mob) {
            super((Mob)mob, Player.class, true);
        }

        public boolean m_8036_() {
            if (this.f_26135_.m_6844_(EquipmentSlot.MAINHAND).m_204117_(ItemTagGenerator.KOBOLD_PACIFICATION_BREADS)) {
                return false;
            }
            return super.m_8036_();
        }
    }
}

